
Class GameCamera

	Public
	
	Property Camera3D:Camera ()
		Return real_camera
	End
	
	Method New (viewport:Recti)

		camera = New Pivot
		
		real_camera			= New Camera (camera)
		real_camera.Near	= 0.01
		real_camera.Far		= 1000.0
		
		real_camera.Viewport = viewport

		' Chase target -- position camera tries to move towards...
		
		chase_target 					= Model.CreateSphere (1, 32, 32, New PbrMaterial (Color.Red))
		chase_target.Alpha				= 0.5
		chase_target.Material.CullMode	= CullMode.None
		chase_target.Visible			= False
		
		Reset ()
		
	End
	
	Method Reset ()

		chase_target.Position = New Vec3f (0.0, 0.0, 0.0)
		camera.Position = New Vec3f (0.0, 15.0, -15.0)

		lastvel = New Vec3f (0, 0, 15)
		prevvel = lastvel

	End
	
	Method Update (player:Rocket)

		If player.Alive
		
			' Camera positioning...
			
			prevvel = lastvel
			
			If player.RocketBody.LinearVelocity.XZ.Length > 4.0 ' TEMP
				lastvel = player.RocketBody.LinearVelocity
			Endif
			
'			chase_target.Position = player.RocketModel.Position - (LongestVec (lastvel * 2.0, lastvel * 5.0)) ' Min lastvel, lastvel * 5, 5, 5?
			chase_target.Position = player.RocketModel.Position - lastvel
	
			camera.Move ((chase_target.Position - camera.Position) * 0.05, True)
			camera.PointAt (player.RocketModel)
		
		Else
		
			' Rising camera post-death...
			
			camera.Move (New Vec3f (0.0, 0.05, -0.05))
			
		Endif

	End
	
	Method ShortestVec:Vec3f (v1:Vec3f, v2:Vec3f)
		If v1.Length < v2.Length Then Return v1 Else Return v2
	End
	
	Method LongestVec:Vec3f (v1:Vec3f, v2:Vec3f)
		If v1.Length > v2.Length Then Return v1 Else Return v2
	End
	
	Method Move (tv:Vec3f, localSpace:Bool = False)
		camera.Move (tv, localSpace)
	End
	
	Method Move (tx:Float, ty:Float, tz:Float)
		camera.Move (tx, ty, tz)
	End
	
	Method PointAt (target:Entity)
		camera.PointAt (target)
	End
	
	Method Position (v3:Vec3f)
		camera.Position = v3
	End
	
	Private
	
	Field camera:Pivot
	Field real_camera:Camera
	
	Field chase_target:Model

	Field lastvel:Vec3f
	Field prevvel:Vec3f

End
